define(['modules/about/about-popup-view'], function(AboutPopupView) {
    'use strict';

    describe('About Popup', function() {
        var view;
        var $view;

        // TODO: upgrade Jasmine, change to beforeAll
        beforeEach(function() {
            view = new AboutPopupView({elAfterClose: '.element-for-focus'});

            $('body').append('<a class="element-for-focus" href="#"></a>');
            view.render();
            $view = view.$el;
        });

        afterEach(function() {
            view.destroy();
            $('.element-for-focus').remove();
        });

        it('has a heading', function() {
            expect($view.find('h2.ui-title').text()).toEqual('About');
        });

        it('has the app name and version number', function () {
            expect($view.find('#version').text())
                .toEqual('Veteran Appointment Requests v0.0.1');
        });

        it('has a description of the app', function () {
            expect($view.find('.ui-content p:first-of-type').text())
                .toEqual('The app is intended to allow Veterans to');
            expect($view.find('.ui-content li:first-of-type').text())
                .toEqual('Directly schedule Primary Care appointments in facilities where a Veteran has a Patient Aligned Care Team (PACT)');
            expect($view.find('.ui-content li:nth-of-type(2)').text())
                .toEqual('Request Primary Care and Mental Health appointments');
            expect($view.find('.ui-content li:nth-of-type(3)').text())
                .toEqual('View or Cancel Booked Appointments');
        });

        it('has an OK button', function() {
            var loginBtn = $view.find('#about-ok-btn');
            expect(loginBtn.text()).toEqual('OK');
        });
    });
});
